import java.util.Scanner;
import java.util.Arrays;

class Disciplina {
    int cod;
    String name;
    int grau;
    boolean v;
    boolean ativ;
    boolean rem;

    public Disciplina() {
        this.cod = 0;
        this.name = "";
        this.grau = 0;
        this.v = false;
        this.ativ = true;
        this.rem = false;
    }
}

public class Curso {
    static final int MAX = 210;
    static Disciplina[] vdisc = new Disciplina[MAX];
    static int[][] adisc = new int[MAX][MAX];
    static int ndisc;
    static int[] listadisc = new int[MAX];
    static int sizelista;
    static Disciplina[][] semestre = new Disciplina[MAX][15];
    static int[] discsem = new int[MAX];
    static int nsemestre;

    public static int finddisc(String str) {
        for (int i = 0; i < ndisc; i++) {
            if (str.equals(vdisc[i].name)) {
                return i;
            }
        }
        return -1;
    }

    public static void DFS_Visit(int u) {
        boolean depend = false;
        vdisc[u].v = true;

        for (int i = 0; i < vdisc[u].grau; i++) {
            if (vdisc[adisc[u][i]].ativ) {
                depend = true;
            }

            if (!vdisc[adisc[u][i]].v && vdisc[adisc[u][i]].ativ) {
                DFS_Visit(adisc[u][i]);
            }
        }

        if (!depend) {
            vdisc[u].rem = true;
            listadisc[sizelista] = u;
            sizelista++;
        }
    }

    public static boolean DFS() {
        boolean thereway = false;
        for (int i = 0; i < ndisc; i++) {
            vdisc[i].v = false;
        }
        for (int i = 0; i < ndisc; i++) {
            if (!vdisc[i].v && vdisc[i].ativ) {
                thereway = true;
                DFS_Visit(i);
            }
        }
        return thereway;
    }

    public static void ordenar() {
        for (int i = 0; i < sizelista - 1; i++) {
            for (int j = i + 1; j < sizelista; j++) {
                if (listadisc[i] > listadisc[j]) {
                    int tmp = listadisc[i];
                    listadisc[i] = listadisc[j];
                    listadisc[j] = tmp;
                }
            }
        }
    }

    public static void ordenar1(int n) {
        for (int i = 0; i < discsem[n] - 1; i++) {
            for (int j = i; j < discsem[n]; j++) {
                if (semestre[n][i].name.compareTo(semestre[n][j].name) > 0) {
                    Disciplina tmp = semestre[n][i];
                    semestre[n][i] = semestre[n][j];
                    semestre[n][j] = tmp;
                }
            }
        }
    }

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        while (true) {
            int n = scanner.nextInt();
            int m = scanner.nextInt();
            if (n == 0 && m == 0) {
                break;
            }

            ndisc = 0;
            for (int i = 0; i < MAX; i++) {
                vdisc[i] = new Disciplina();
                vdisc[i].cod = i;
                vdisc[i].name = "";
                vdisc[i].grau = 0;
                vdisc[i].ativ = true;
                vdisc[i].rem = false;
            }

            for (int i = 0; i < n; i++) {
                String strdisc = scanner.next();
                int posdisc = finddisc(strdisc);
                if (posdisc == -1) {
                    vdisc[ndisc].name = strdisc;
                    posdisc = ndisc;
                    ndisc++;
                }
                int k = scanner.nextInt();
                for (int j = 0; j < k; j++) {
                    String strdep = scanner.next();
                    int posdep = finddisc(strdep);
                    if (posdep == -1) {
                        vdisc[ndisc].name = strdep;
                        posdep = ndisc;
                        ndisc++;
                    }
                    adisc[posdisc][vdisc[posdisc].grau] = posdep;
                    vdisc[posdisc].grau++;
                }
            }

            nsemestre = 0;
            while (true) {
                sizelista = 0;
                if (!DFS()) {
                    break;
                }
                ordenar();

                discsem[nsemestre] = Math.min(m, sizelista);

                for (int i = 0; i < m; i++) {
                    if (i < sizelista) {
                        vdisc[listadisc[i]].ativ = false;
                        semestre[nsemestre][i] = vdisc[listadisc[i]];
                    }
                }

                ordenar1(nsemestre);

                nsemestre++;
            }

            System.out.println("Formatura em " + nsemestre + " semestres");
            for (int i = 0; i < nsemestre; i++) {
                System.out.print("Semestre " + (i + 1) + " :");
                for (int j = 0; j < discsem[i]; j++) {
                    System.out.print(" " + semestre[i][j].name);
                }
                System.out.println();
            }
        }

        scanner.close();
    }
}